/*
 * Copyright 2017 Square Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squareup.catalog.demo;

public interface Logger {

  /** Logs general information. */
  void info(String message);

  /** Logs an error messages. */
  void error(String message);

  /**
   * Default implementation of {@link Logger} that logs messages to the System output.
   */
  class SystemLogger implements Logger {

    @Override
    public void info(String message) {
      System.out.println(message);
    }

    @Override
    public void error(String message) {
      System.err.println(message);
    }
  }
}
