/*
 * Copyright 2017 Square Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squareup.catalog.demo.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Provides the one instance of Java setup to serialize Wire-generated proto classes.
 */
public class GsonProvider {

  private static Gson INSTANCE = new GsonBuilder().create();

  public static Gson gson() {
    return INSTANCE;
  }

  private GsonProvider() {
  }
}
